/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.registry;

import gloridifice.watersource.registry.BlockRegistry;
import gloridifice.watersource.registry.ItemRegistry;
import gloridifice.watersource.registry.RegistryModule;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class FluidRegistry
extends RegistryModule {
    public static final ResourceLocation STILL_FLUID_TEXTURE = new ResourceLocation("watersource", "block/fluid/water_still");
    public static final ResourceLocation FLOWING_FLUID_TEXTURE = new ResourceLocation("watersource", "block/fluid/water_flow");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"watersource");
    public static RegistryObject<FlowingFluid> PURIFIED_WATER = FLUIDS.register("purified_water", () -> new ForgeFlowingFluid.Source(PURIFIED_WATER_PROPERTIES));
    public static RegistryObject<FlowingFluid> PURIFIED_WATER_FLOWING = FLUIDS.register("purified_water_flowing", () -> new ForgeFlowingFluid.Flowing(PURIFIED_WATER_PROPERTIES));
    public static RegistryObject<FlowingFluid> SOUL_WATER = FLUIDS.register("soul_water", () -> new ForgeFlowingFluid.Source(SOUL_WATER_PROPERTIES));
    public static RegistryObject<FlowingFluid> SOUL_WATER_FLOWING = FLUIDS.register("soul_water_flowing", () -> new ForgeFlowingFluid.Flowing(SOUL_WATER_PROPERTIES));
    public static RegistryObject<FlowingFluid> COCONUT_MILK = FLUIDS.register("coconut_milk", () -> new ForgeFlowingFluid.Source(COCONUT_MILK_PROPERTIES));
    public static RegistryObject<FlowingFluid> COCONUT_MILK_FLOWING = FLUIDS.register("coconut_milk_flowing", () -> new ForgeFlowingFluid.Flowing(COCONUT_MILK_PROPERTIES));
    public static ForgeFlowingFluid.Properties PURIFIED_WATER_PROPERTIES = new ForgeFlowingFluid.Properties(PURIFIED_WATER, PURIFIED_WATER_FLOWING, FluidAttributes.builder((ResourceLocation)STILL_FLUID_TEXTURE, (ResourceLocation)FLOWING_FLUID_TEXTURE).color(-868565505).viscosity(1000)).slopeFindDistance(3).explosionResistance(100.0f).bucket(() -> ItemRegistry.PURIFIED_WATER_BUCKET).block(() -> BlockRegistry.BLOCK_PURIFIED_WATER_FLUID);
    public static ForgeFlowingFluid.Properties SOUL_WATER_PROPERTIES = new ForgeFlowingFluid.Properties(SOUL_WATER, SOUL_WATER_FLOWING, FluidAttributes.builder((ResourceLocation)STILL_FLUID_TEXTURE, (ResourceLocation)FLOWING_FLUID_TEXTURE).color(-864919739).viscosity(1000)).slopeFindDistance(3).explosionResistance(100.0f).bucket(() -> ItemRegistry.SOUL_WATER_BUCKET).block(() -> BlockRegistry.BLOCK_SOUL_WATER_FLUID);
    public static ForgeFlowingFluid.Properties COCONUT_MILK_PROPERTIES = new ForgeFlowingFluid.Properties(COCONUT_MILK, COCONUT_MILK_FLOWING, FluidAttributes.builder((ResourceLocation)STILL_FLUID_TEXTURE, (ResourceLocation)FLOWING_FLUID_TEXTURE).color(-857020191).viscosity(1000)).slopeFindDistance(3).explosionResistance(100.0f).bucket(() -> ItemRegistry.COCONUT_MILK_BUCKET).block(() -> BlockRegistry.BLOCK_COCONUT_JUICE_FLUID);

    protected static ForgeFlowingFluid.Source createSource(String regName, ForgeFlowingFluid.Properties properties) {
        ForgeFlowingFluid.Source fluid = new ForgeFlowingFluid.Source(properties);
        fluid.setRegistryName(regName);
        return fluid;
    }

    protected static ForgeFlowingFluid.Flowing createFlowing(String regName, ForgeFlowingFluid.Properties properties) {
        ForgeFlowingFluid.Flowing flowingFluid = new ForgeFlowingFluid.Flowing(properties);
        flowingFluid.setRegistryName(regName);
        return flowingFluid;
    }
}

